#include "stdafx.h"
#include "RAS.h"

#include<stdlib.h>
#include<stdio.h>
#include<math.h>
#include "RAS_Doc.h"
#include "Figure.h"
#include "SharedConstants.h"
#include "RAS_View.h"
#include "SinTable.h"
#include "MainFrm.h"
#include "Dialog_Box.h"
#include "StringEdit.h"
#include "AcceptOneNum.h"
#include "FigureProperty.h"
#include "Trial.h"
#include "VarDefinitionsSDF.h"
#include "Dialog_ECodeContitions.h"

void CRASView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: Add your message handler code here and/or call default

	m_KeyCode=-1;
	CView::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CRASView::SetECodeConditions_Dialog()
{
	char Source[1024]; 
	CECodeContitions ECodeBox;
	ECodeBox.m_MustExiestECodes         =m_pSpotlightFig->m_MustExiestECodes;
	ECodeBox.m_MustNotExiestECodes      =m_pSpotlightFig->m_MustNotExiestECodes;
	ECodeBox.m_OneOfThemMustExiestECodes=m_pSpotlightFig->m_OneOfThemMustExiestECodes;
	m_IsEditOkayed=0;
	if(ECodeBox.DoModal()==IDOK){
		m_IsEditOkayed=1;
		m_pSpotlightFig->m_MustExiestECodes         =ECodeBox.m_MustExiestECodes;
		m_pSpotlightFig->m_MustNotExiestECodes      =ECodeBox.m_MustNotExiestECodes;
		m_pSpotlightFig->m_OneOfThemMustExiestECodes=ECodeBox.m_OneOfThemMustExiestECodes;
	}
}

void CRASView::OnEnChangeEditString1()
{
	StringEdit	ParameterBOX;
	char Source[1024]; 

	if(m_CallingFrom==1)ParameterBOX.m_UserInputString1=m_GlobalTitle;
	else if(m_CallingFrom==2){
		sprintf(Source,"Title: %s",m_pSpotlightFig->m_Title.NameString);
		ParameterBOX.m_UserInputString1=Source;
	}
	else if(m_CallingFrom==3){
		sprintf(Source,"Ch: %d",m_pSpotlightFig->m_ChanID);
		ParameterBOX.m_UserInputString1=Source;
	}
	else if(m_CallingFrom==4){
		sprintf(Source,"Nn: %d",m_pSpotlightFig->m_NnID);
		ParameterBOX.m_UserInputString1=Source;
	}
	else if(m_CallingFrom==5){
		sprintf(Source,"Aln: %d",m_pSpotlightFig->m_Alignment.m_AssociatedVar);
		ParameterBOX.m_UserInputString1=Source;
	}
	m_IsEditOkayed=0;
	if(ParameterBOX.DoModal()==IDOK){
		m_IsEditOkayed=1;
		if(m_CallingFrom==1)m_GlobalTitle=ParameterBOX.m_UserInputString1;
		else if(m_CallingFrom==2){
			ParameterBOX.m_UserInputString1.Replace("Title:",""); ParameterBOX.m_UserInputString1.TrimLeft();
			m_pSpotlightFig->m_Title.NameString=ParameterBOX.m_UserInputString1;
		}
		else if(m_CallingFrom==3||m_CallingFrom==4||m_CallingFrom==5||m_CallingFrom==7){
			strcpy(Source,ParameterBOX.m_UserInputString1);
			int TmpID;
			if(Find_Last_Num_inString(Source, TmpID)==-1)return;
			if(m_CallingFrom==3){
				if(TmpID>=0 && TmpID<NUM_NN_AI_CHAN)m_pSpotlightFig->m_ChanID=TmpID;
				else AfxMessageBox("TmpID<0 || TmpID>=NUM_NN_AI_CHAN");
			}
			else if(m_CallingFrom==4){//Neuron ID
				if(TmpID>=0 && TmpID<3)m_pSpotlightFig->m_NnID=TmpID;
				else AfxMessageBox("TmpID<0 || TmpID>=3");
			}
			else if(m_CallingFrom==5){
				m_pSpotlightFig->m_Alignment.m_AssociatedVar=TmpID;
			}
		}
	}
}

#include "Dialog_EcodeToMark.h"
void CRASView::OnECodeToMarkDialog()
{
	CEcodeToMark	ParameterBOX;
	ParameterBOX.m_0_TheFirstRadioEnabled=!m_pSpotlightFig->m_EcodeToMarkLabel.status;//0 means the first radio (Enable Mark) is checked.
	ParameterBOX.m_EcodeToMark=m_pSpotlightFig->m_EcodeToMarkLabel.m_AssociatedVar;
	m_IsEditOkayed=0;
	if(ParameterBOX.DoModal()==IDOK){
		char tmpStr[64];
		m_IsEditOkayed=1;
		m_pSpotlightFig->m_EcodeToMarkLabel.m_AssociatedVar=ParameterBOX.m_EcodeToMark;
		if(ParameterBOX.m_0_TheFirstRadioEnabled==0){//0 means the first radio (Enable Mark) is checked.
			sprintf(tmpStr,"M:%d",m_pSpotlightFig->m_EcodeToMarkLabel.m_AssociatedVar);  
			m_pSpotlightFig->m_EcodeToMarkLabel.status=1; //Yes enabled
		}
		else{
			sprintf(tmpStr,"M:");  
			m_pSpotlightFig->m_EcodeToMarkLabel.status=0; //No disenabled
		}
		m_pSpotlightFig->m_EcodeToMarkLabel.NameString=tmpStr;
	}
}


void CRASView::OnFigureProperty()
{
	CFigureProperty	PropertyDialogue;
	int prvNnID, prvAlignEcode, prvPreAlgnPeriod, FigCleared;
	double prvSigma;

	prvNnID			=m_pSpotlightFig->m_NnID;
	//prvAlignEcode	=m_pSpotlightFig->m_Alignment.m_AssociatedVar;
	//prvPreAlgnPeriod=m_pSpotlightFig->m_dMinX;
	prvSigma		=m_pSpotlightFig->m_dSigma;

	PropertyDialogue.m_ChannID			=m_pSpotlightFig->m_ChanID;
	PropertyDialogue.m_NeuronID			=m_pSpotlightFig->m_NnID;
	//PropertyDialogue.m_AlignmentEcode	=m_pSpotlightFig->m_Alignment.m_AssociatedVar;
	//PropertyDialogue.m_PreAlignPeriod_ms=m_pSpotlightFig->m_dMinX;
	PropertyDialogue.m_dSigma			=m_pSpotlightFig->m_dSigma;
	if(PropertyDialogue.DoModal()==IDOK){
		int row, clm;
		CFigure * pFig;
		CClientDC objDC(this);
		for(clm=0;clm<m_dHowManyClmns;clm++){
			for(row=0;row<m_dHowManyRows;row++){
				FigCleared=0;
				pFig=&m_Fig[row][clm][0];
				if(pFig->m_Captured!=1||pFig->m_Deleted==1)continue;
				if(pFig->m_ChanID !=PropertyDialogue.m_ChannID || pFig->m_NnID !=PropertyDialogue.m_NeuronID){
					if(pFig->m_ChanID !=PropertyDialogue.m_ChannID){
						pFig->m_ChanID =PropertyDialogue.m_ChannID;
					}
					if(pFig->m_NnID !=PropertyDialogue.m_NeuronID){
						pFig->m_NnID =PropertyDialogue.m_NeuronID;
					}
					pFig->EmptyHistogramAndSpikes();
					DrawOneFigure(pFig, 1);
					pFig->DispRecordingSource(&objDC, &m_DC[0]);
					FigCleared=1;
				}
				if(pFig->m_dSigma !=PropertyDialogue.m_dSigma){
					pFig->m_dSigma =PropertyDialogue.m_dSigma;
					if(FigCleared==0){//In the case the figure keeps spike data (i.e., not wiped clean)
						pFig->ReMake_SDF();
						DrawOneFigure(pFig, 1);
						pFig->DispSpkRaster_OneType(&m_DC[0], m_toShowRaster);
						pFig->DispSDF_OneType(&m_DC[0], m_toShowSDF);
						pFig->RefreshFrame(&objDC,&m_DC[0]); 
					}
				}	
			}						
		}
	}						
}
