// OscilloscopeView.cpp : implementation of the COscilloscopeView class

#include "stdafx.h"
#include "Oscilloscope.h"

#include<stdlib.h>
#include<stdio.h>
#include<math.h>
#include "OscilloscopeDoc.h"
#include "FiguresOsc.h"
#include "OscilloscopeView.h"
#include "SinTable.h"
#include "MainFrm.h"
#include "DialogueBox.h"
#include "StringEdit.h"


void COscilloscopeView::OnChangeParameters() 
{
	CDialogueBox	ParameterBOX;

	double InvScaleFactor;
	if(m_selectedChan<NUM_NN_AI_CHAN)InvScaleFactor=(DATA_SAMPLING_RATE)/1000.; 
	else InvScaleFactor=(BEHAVIOR_DATA_SAMPLING_RATE)/1000.; 

	ParameterBOX.m_dVariable1=m_dMaximumX/InvScaleFactor; //Convert the data points to ms
	ParameterBOX.m_dVariable2=m_dMinimumX/InvScaleFactor; //Convert the data points to ms
	ParameterBOX.m_dVariable3=m_dMaximumY;
	ParameterBOX.m_dMinimumY=m_dMinimumY;
	if(ParameterBOX.DoModal()==IDOK){
		if(ParameterBOX.m_dVariable1<=ParameterBOX.m_dVariable2||ParameterBOX.m_dVariable3<=ParameterBOX.m_dMinimumY){AfxMessageBox("m_dMaximumX<=m_dMinimumX OR m_dMaximumY<=m_dMinimumY ==> Try again", MB_OK); return;}
		else{
			m_dMaximumX=ParameterBOX.m_dVariable1*InvScaleFactor; //Convert ms the data points 
			m_dMinimumX=ParameterBOX.m_dVariable2*InvScaleFactor; //Convert ms the data points 
			m_dMaximumY=ParameterBOX.m_dVariable3;
			m_dMinimumY=ParameterBOX.m_dMinimumY;
		}
	}
}

void COscilloscopeView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: Add your message handler code here and/or call default

	m_KeyCode=-1;
	CView::OnKeyUp(nChar, nRepCnt, nFlags);
}

void COscilloscopeView::OnEnChangeEditString1()
{
	StringEdit	ParameterBOX;

	if(m_CallingFrom==1)ParameterBOX.m_UserInputString1=m_GlobalTitle;
	else if(m_CallingFrom==2)ParameterBOX.m_UserInputString1=m_pSpotlightFig->m_Title.NameString;
	if(ParameterBOX.DoModal()==IDOK){
		if(m_CallingFrom==1)m_GlobalTitle=ParameterBOX.m_UserInputString1;
		else if(m_CallingFrom==2)m_pSpotlightFig->m_Title.NameString=ParameterBOX.m_UserInputString1;
	}
}
